document.addEventListener("DOMContentLoaded", function () {

    const annees = ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'];
    const indexAnnees = annees.map((_, i) => i);
    const decalage = 0.2;

    const xIA    = indexAnnees.map(v => v - decalage);
    const xMonde = indexAnnees.map(v => v + decalage);

    const opacitesTemps = annees.map((_, i) => (i <= 5 ? 1 : 0.35));

    const couleurAutres   = '#7B4A3A';   
    const couleurVent     = '#8A63C2';   
    const couleurSolaire  = '#C0392B';  
    const couleurNuc      = '#4CAF50';   
    const couleurGaz      = '#F39C12';   
    const couleurCharbon  = '#2E6DA4';  

    let data = [

        {
            type: "bar",
            x: xIA,
            y: [95, 112, 120, 125, 145, 165, 175, 200, 218, 225, 235, 230, 225, 215, 212, 205],
            name: 'Charbon IA',
            marker: {  color: couleurCharbon, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xIA,
            y: [80, 85, 92, 105, 120, 140, 170, 205, 235, 260, 270, 275, 280, 285, 290, 295],
            name: 'Gaz naturel IA',
            marker: { color: couleurGaz, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xIA,
            y: [45, 50, 52, 60, 70, 82, 90, 102, 110, 118, 125, 150, 175, 200, 225, 245],
            name: 'Nucléaire IA',
            marker: { color: couleurNuc, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xIA,
            y: [10, 14, 18, 23, 30, 42, 55, 75, 105, 135, 160, 185, 205, 225, 240, 252],
            name: 'PV solaire IA',
            marker: { color: couleurSolaire, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xIA,
            y: [25, 30, 36, 42, 48, 58, 66, 82, 102, 125, 148, 165, 182, 195, 205, 212],
            name: 'Vent IA',
            marker: { color: couleurVent, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xIA,
            y: [47, 47, 49, 53, 62, 74, 83, 99, 110, 119, 125.5, 129, 131.5, 133, 132.5, 132],
            name: 'Autres IA',
            marker: { color: couleurAutres, opacity: opacitesTemps }
        },

        {
            type: "bar",
            x: xMonde,
            y: [9500, 10300, 10500, 10600, 10800, 10800, 10900, 10600, 10200, 9700, 9200, 8700, 8300, 7800, 7400, 7000],
            name: 'Charbon Monde',
            marker: { color: couleurCharbon, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xMonde,
            y: [6400, 6600, 6500, 6500, 6700, 6900, 6900, 7000, 7000, 7000, 6900, 6800, 6700, 6700, 6700, 6600],
            name: 'Gaz naturel Monde',
            marker: { color: couleurGaz, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xMonde,
            y: [2700, 2800, 2700, 2800, 2800, 2800, 2900, 3000, 3000, 3100, 3300, 3400, 3500, 3600, 3700, 3700],
            name: 'Nucléaire Monde',
            marker: { color: couleurNuc, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xMonde,
            y: [800, 1000, 1300, 1600, 2100, 2600, 3300, 4000, 4800, 5600, 6500, 7300, 8100, 9000, 9800, 10700],
            name: 'PV solaire Monde',
            marker: { color: couleurSolaire, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xMonde,
            y: [1600, 1900, 2100, 2300, 2600, 2900, 3200, 3600, 4100, 4500, 5000, 5600, 6100, 6600, 7100, 7500],
            name: 'Vent Monde',
            marker: { color: couleurVent, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: xMonde,
            y: [4500, 4800, 5000, 5700, 6153, 5000, 5100, 5200, 5200, 5300, 5400, 5500, 5600, 5700, 5800, 5900],
            name: 'Autres Monde',
            marker: { color: couleurAutres, opacity: opacitesTemps }
        }

    ];

    const totalIA = annees.map((_, i) =>
        data[0].y[i] + data[1].y[i] + data[2].y[i] +
        data[3].y[i] + data[4].y[i] + data[5].y[i]
    );

    const totalMonde = annees.map((_, i) =>
        data[6].y[i] + data[7].y[i] + data[8].y[i] +
        data[9].y[i] + data[10].y[i] + data[11].y[i]
    );

    const annotationsIA = annees.map((annee, i) => {
        const pourcentage = (totalIA[i] / totalMonde[i] * 100).toFixed(2);
        return {
            x: xIA[i],
            y: totalIA[i] + 1500,
            text: `${pourcentage}%`,
            showarrow: false,
            font: { size: 12, couleur: "#000", family: "Arial" },
            align: "center"
        };
    });

    let layout = {
        title: {
            text: "Consommation énergétique IA vs Monde (2020–2035)",
            font: { size: 22 }
        },
        barmode: "relative",
        xaxis: {
            title: "Année",
            tickvals: indexAnnees,
            ticktext: annees
        },
        yaxis: { title: "TWh" },
        annotations: annotationsIA
    };

    Plotly.newPlot('barre1', data, layout);
    const btnSource = document.getElementById('btn-source-barre1');
    const modal = document.getElementById('source-barre1');
    const btnClose = modal ? modal.querySelector('.close-btn') : null;

    if (btnSource && modal && btnClose) {
        btnSource.addEventListener('click', () => {
            modal.setAttribute('aria-hidden', 'false');
        });

        btnClose.addEventListener('click', () => {
            modal.setAttribute('aria-hidden', 'true');
        });

        modal.addEventListener('click', (e) => {
            if (e.target === modal) {
                modal.setAttribute('aria-hidden', 'true');
            }
        });

        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape' && modal.getAttribute('aria-hidden') === 'false') {
                modal.setAttribute('aria-hidden', 'true');
            }
        });

    }
});




document.addEventListener("DOMContentLoaded", function () {

    const annees = ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'];
    const opacitesTemps = annees.map((_, i) => (i <= 5 ? 1 : 0.35));

    const couleurAutres   = '#7B4A3A';   
    const couleurVent     = '#8A63C2';   
    const couleurSolaire  = '#C0392B';  
    const couleurNuc      = '#4CAF50';   
    const couleurGaz      = '#F39C12';   
    const couleurCharbon  = '#2E6DA4';  

    let data = [

        {
            type: "bar",
            x: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            y: [95, 112, 120, 125, 145, 165, 175, 200, 218, 225, 235, 230, 225, 215, 212, 205],
            name: 'Charbon IA',
            offsetgroup: "charbon_IA",
            marker: { color: couleurCharbon, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            y: [80, 85, 92, 105, 120, 140, 170, 205, 235, 260, 270, 275, 280, 285, 290, 295],
            name: 'Gaz naturel IA',
            offsetgroup: "gaz_IA",
            marker: { color: couleurGaz, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            y: [45, 50, 52, 60, 70, 82, 90, 102, 110, 118, 125, 150, 175, 200, 225, 245],
            name: 'Nucléaire IA',
            offsetgroup: "nucleaire_IA",
            marker: { color: couleurNuc, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            y: [10, 14, 18, 23, 30, 42, 55, 75, 105, 135, 160, 185, 205, 225, 240, 252],
            name: 'PV solaire IA',
            offsetgroup: "pv_solaire",
            marker: { color: couleurSolaire, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            y: [25, 30, 36, 42, 48, 58, 66, 82, 102, 125, 148, 165, 182, 195, 205, 212],
            name: 'Vent IA',
            offsetgroup: "vent",
            marker: { color: couleurVent, opacity: opacitesTemps }
        },
        {
            type: "bar",
            x: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            y: [47, 47, 49, 53, 62, 74, 83, 99, 110, 119, 125.5, 129, 131.5, 133, 132.5, 132],
            name: 'Autres IA',
            offsetgroup: "autres_total",
            marker: { color: couleurAutres, opacity: opacitesTemps }
        }

    ];

    let layout = {
        title: {
            text: "Zoom sur la consommation énergétique IA (2020–2035)",
            font: { size: 22 }
        },
        barmode: "stack",          
        xaxis: { title: "Année" ,
            tickmode: "array",
            tickvals: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
            ticktext: ['2020','2021','2022','2023','2024','2025','2026','2027','2028','2029','2030','2031','2032','2033','2034','2035'],
        },
        yaxis: { title: "TWh" },
    };

    Plotly.newPlot('barre2', data, layout);
    const btnSource = document.getElementById('btn-source-barre2');
    const modal = document.getElementById('source-barre2');
    const btnClose = modal ? modal.querySelector('.close-btn') : null;

    if (btnSource && modal && btnClose) {
        btnSource.addEventListener('click', () => {
            modal.setAttribute('aria-hidden', 'false');
        });

        btnClose.addEventListener('click', () => {
            modal.setAttribute('aria-hidden', 'true');
        });

        modal.addEventListener('click', (e) => {
            if (e.target === modal) {
                modal.setAttribute('aria-hidden', 'true');
            }
        });

        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape' && modal.getAttribute('aria-hidden') === 'false') {
                modal.setAttribute('aria-hidden', 'true');
            }
        });

    }
    
});

var couleurs = ["#1B3A57", "#FF8C00", "#FF00FF"];

var data = [
    {
        type: "pie",
        labels: ['Consommation totale', 'Datacenters', 'IA'],
        values: [4830, 176, 28],
        name: "États-Unis",
        domain: { row: 0, column: 0 },
        marker: { colors: couleurs },
    },
    {
        type: "pie",
        labels: ['Consommation totale', 'Datacenters', 'IA'],
        values: [8350, 100, 16],
        name: "Chine",
        domain: { row: 0, column: 1 },
        marker: { colors: couleurs },
    },
    {
        type: "pie",
        labels: ['Consommation totale', 'Datacenters', 'IA'],
        values: [3770, 96, 15],
        name: "UE",
        domain: { row: 0, column: 2 },
        marker: { colors: couleurs },
    }
];

var layout = {
    title: {
        text: "Répartition énergétique – IA, Datacenters et consommation globale",
        font: { size: 26 }
    },
    grid: { rows: 1, columns: 3 },
    legend: {
        orientation: "h",
        x: 0.5,
        xanchor: "center",
        y: -0.3,     
        font: { size: 14 }
    },

    margin: {
        l: 20,
        r: 20,
        t: 150,
        b: 150
    },

};

Plotly.newPlot('camembert', data, layout);
const btnSource = document.getElementById('btn-source-graph3');
const modal = document.getElementById('source-graph3');
const btnClose = modal ? modal.querySelector('.close-btn') : null;

if (btnSource && modal && btnClose) {
    btnSource.addEventListener('click', () => {
        modal.setAttribute('aria-hidden', 'false');
    });

    btnClose.addEventListener('click', () => {
        modal.setAttribute('aria-hidden', 'true');
    });

    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.setAttribute('aria-hidden', 'true');
        }
    });

    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal.getAttribute('aria-hidden') === 'false') {
            modal.setAttribute('aria-hidden', 'true');
        }
    });
}
